from flask import request, jsonify, session
from PyPDF2 import PdfReader
from io import BytesIO
from docx import Document
import uuid
import logging

logger = logging.getLogger(__name__)

def process_pdf_content(pdf_file):
    """Extract text from a PDF file."""
    try:
        pdf_file.seek(0)
        pdf_reader = PdfReader(BytesIO(pdf_file.read()))
        text_content = "\n".join([page.extract_text() or "" for page in pdf_reader.pages])
        return text_content.strip()
    except Exception as e:
        logger.error(f"Error processing PDF: {str(e)}")
        return None


def process_docx_content(docx_file):
    """Extract text from a DOCX file."""
    try:
        docx_file.seek(0)
        document = Document(BytesIO(docx_file.read()))
        text_content = "\n".join([para.text for para in document.paragraphs])
        return text_content.strip()
    except Exception as e:
        logger.error(f"Error processing DOCX: {str(e)}")
        return None
