import os
import sys

# Add the project root directory to Python path
project_root = os.path.dirname(os.path.abspath(__file__))
sys.path.append(project_root)

# Update the import to use the correct path
from app.utils.celery_app import celery
from app.utils import email_campaign, email_reply_scanner, call_campaign

# Import tasks to ensure they're registered
from app.utils.email_campaign import send_campaign_emails
from app.utils.email_reply_scanner import scan_email_replies
from app.utils.call_campaign import process_campaign
from app.tasks import process_campaign as process_campaign_task, test_connection  # Explicitly import tasks

# Configure logging
import logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

# Create Flask application context
from app import create_app
app = create_app()
app.app_context().push()

# Configure Celery Beat schedule
celery.conf.beat_schedule = {
    # 'check-scheduled-campaigns': {
    #     'task': 'app.utils.email_campaign.check_and_send_scheduled_campaigns',
    #     'schedule': 60.0,  # Run every minute
    # },
    # 'scan-email-replies': {
    #     'task': 'app.utils.email_reply_scanner.scan_email_replies',
    #     'schedule': 300.0,  # Run every 5 minutes
    # }
}

# Log the registered tasks
logger.info("Registered tasks:")
for task_name in celery.tasks.keys():
    logger.info(f"- {task_name}")

if __name__ == '__main__':
    logger.info("Starting Celery...")
    celery.start()

